// $Id: CDouble.cpp,v 1.4 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CDouble.hpp"
using Exponent::Basics::CDouble;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CDouble, CCountedObject);

//	===========================================================================
CDouble::CDouble(const double  value) : m_value(0.0)
{
	EXPONENT_CLASS_CONSTRUCTION(CDouble);
	this->setValue(value);
}

//	===========================================================================
CDouble::~CDouble()
{
	EXPONENT_CLASS_DESTRUCTION(CDouble);
	// Nothing to do...
}

//	===========================================================================
void CDouble::setValue(const CDouble &value)
{
	this->setValue(value.getValue());
}

//	===========================================================================
void CDouble::setValue(const double  value)
{
	m_value = value;
}

//	===========================================================================
double  CDouble::getValue() const
{
	return m_value;
}

//	===========================================================================
CString CDouble::getValueAsString(const long decimalPlaces) const
{
	// First we store a string that has the first part of the final string
	char flag[256] = "%.0";

	// Now store the position
	char buffer[20];
	sprintf(buffer, "%li", decimalPlaces);

	// Copy the decimal places to the end of the flag
	strcat(flag, buffer);

	// Now copy in the format flag
	strcat(flag, "f");

	// Create the string
	CString string;

	// Set teh string
	string.setStringWithFormat(flag, m_value);

	// Return the string
	return string;
}

//	===========================================================================
CDouble &CDouble::operator = (const CDouble &value)
{
	m_value = value.getValue();
	return (*this);
}

//	===========================================================================
CDouble &CDouble::operator = (const double  value)
{
	m_value = value;
	return (*this);
}

//	===========================================================================
bool CDouble::operator == (const CDouble &value)
{
	return (m_value == value.getValue());
}

//	===========================================================================
bool CDouble::operator == (const double  value)
{
	return (m_value == value);
}

//	===========================================================================
bool CDouble::operator != (const CDouble &value)
{
	return (m_value != value.getValue());
}

//	===========================================================================
bool CDouble::operator != (const double  value)
{
	return (m_value != value);
}

//	===========================================================================
CDouble &CDouble::operator + (const CDouble &value)
{
	m_value += value.getValue();
	return (*this);
}

//	===========================================================================
CDouble &CDouble::operator + (const double  value)
{
	m_value += value;
	return (*this);
}

//	===========================================================================
CDouble &CDouble::operator - (const CDouble &value)
{
	m_value -= value.getValue();
	return (*this);
}

//	===========================================================================
CDouble &CDouble::operator - (const double  value)
{
	m_value -= value;
	return (*this);
}

//	===========================================================================
CDouble &CDouble::operator * (const CDouble &value)
{
	m_value *= value.getValue();
	return (*this);
}

//	===========================================================================
CDouble &CDouble::operator * (const double  value)
{
	m_value *= value;
	return (*this);
}

//	===========================================================================
CDouble &CDouble::operator / (const CDouble &value)
{
	const double  val = value.getValue();
	if (val != 0.0)
	{
		m_value /= val;
	}
	else
	{
		m_value = 0.0;
	}
	return (*this);
}

//	===========================================================================
CDouble &CDouble::operator / (const double  value)
{
	if (value != 0.0)
	{
		m_value /= value;
	}
	else
	{
		m_value = 0.0;
	}
	return (*this);
}

//	===========================================================================
CDouble &CDouble::operator += (const CDouble &value)
{
	m_value += value.getValue();
	return (*this);
}

//	===========================================================================
CDouble &CDouble::operator += (const double  value)
{
	m_value += value;
	return (*this);
}

//	===========================================================================
CDouble &CDouble::operator -= (const CDouble &value)
{
	m_value -= value.getValue();
	return (*this);
}

//	===========================================================================
CDouble &CDouble::operator -= (const double  value)
{
	m_value -= value;
	return (*this);
}

//	===========================================================================
bool CDouble::operator ! ()
{
	return (m_value == 0.0);
}

//	===========================================================================
void CDouble::getObjectDescription(char *string, const long size) const
{
	this->getValueAsString().getString(string, size);
}